function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 264);

T = World_Economy_Cartel_w_inv_shocks.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(122) = exp(y(28))*exp(y(31))*T(99);
T(123) = T(36)+T(35)*y(23)*(-(exp(y(28))*T(26)));
T(124) = (-(exp(y(111))*exp(y(38))*exp(y(103))));
T(125) = (-T(22))*T(99);
T(126) = T(28)*(-T(22))+T(22)*y(68);
T(127) = (-(exp(y(6))*exp((-y(62)))*exp(y(10))));
T(128) = T(45)+params(30)*y(119)*exp(y(34))*params(6)*params(5)*exp(params(5)*y(38))+T(56);
T(129) = exp(y(6))*params(6)*exp(y(53))*params(5)*exp(params(5)*(y(10)-y(62)));
T(130) = y(80)*T(116)+y(76)*T(117)+y(68)*exp(y(6))*params(6)*exp(y(53))*(-params(5))*params(5)*exp(params(5)*(y(10)-y(62)));
T(131) = (-(exp(y(6))*(-(exp((-y(62)))*exp(y(10))))));
T(132) = T(43)+T(50)+params(30)*y(119)*exp(y(33))*params(6)*exp(y(113))*params(5)*params(5)*exp(params(5)*(y(37)-y(114)));
T(133) = (-(T(26)*(exp(y(28))*exp(y(11))+y(40)*(-exp(y(11)))-params(6)*exp(y(53))*params(5)*exp(params(5)*y(11)))));
T(134) = T(35)*y(23)*T(26)*params(6)*params(5)*exp(y(53))*(params(5)-1)*exp(y(11)*(params(5)-1))+T(35)*y(21)*T(133);
T(135) = T(35)*y(23)*T(26)*params(6)*params(5)*exp(y(53))*(params(5)-1)*exp(y(11)*(params(5)-1))+T(35)*y(21)*(-(T(26)*(-(params(6)*exp(y(53))*params(5)*exp(params(5)*y(11))))));
T(136) = exp(y(111))*params(6)*params(5)*exp(y(113))*(params(5)-1)*(params(5)-1)*exp(y(38)*(params(5)-1));
T(137) = y(74)*T(136);
T(138) = (-(exp(y(111))*(exp(y(38))*exp(y(103))+y(104)*(-exp(y(38)))-params(6)*exp(y(113))*params(5)*params(5)*exp(params(5)*y(38)))));
T(139) = y(71)*T(138);
T(140) = T(35)*y(21)*(-(T(26)*(1-exp(y(11)))))+T(35)*T(26)*y(23);
T(141) = T(8)*getPowerDeriv(T(8),T(13),2);
T(142) = T(8)*T(141);
T(143) = T(57)+T(142);
T(144) = T(8)*getPowerDeriv(T(8),T(1),2);
T(145) = T(8)*T(144);
T(146) = T(58)+T(145);
T(147) = params(11)*T(146);
T(148) = getPowerDeriv(T(9),T(10),2);
T(149) = exp(y(106))*getPowerDeriv(exp(y(106)),T(1),1);
T(150) = getPowerDeriv(T(71),T(10),2);
T(151) = exp(y(43))*getPowerDeriv(exp(y(43)),T(11),2);
T(152) = exp(y(43))*T(151);
T(153) = T(60)+T(152);
T(154) = y(66)*(-(T(19)*T(16)*T(61)*T(89)+T(5)*T(19)*T(61)*T(91)))+y(65)*(-(T(17)*T(3)*T(62)*T(91)+T(3)*T(16)*T(62)*T(93)));
T(155) = (-(T(5)*T(19)*T(16)*T(60)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(50))));
T(156) = (-(T(17)*T(3)*T(16)*T(60)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(50))));
T(157) = y(66)*T(155)+y(65)*T(156);
T(158) = exp(y(107))*getPowerDeriv(exp(y(107)),T(11),1);
T(159) = (1-params(11))*(1-params(3))*exp(T(1)*y(112))*T(158);
T(160) = (-(T(64)*(T(79)*T(78)*(1-params(11))*params(3)*exp(T(1)*y(112))*T(158)+T(81)*T(76)*(1-params(11))*params(3)*exp(T(1)*y(112))*T(158))));
T(161) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3),1);
T(162) = T(5)*T(161);
T(163) = T(2)*T(95)*T(162);
T(164) = exp(y(13))*getPowerDeriv(exp(y(13)),params(3)-1,1);
T(165) = (-(T(5)*(T(16)*T(61)*T(164)+T(19)*T(61)*T(90)*T(162))));
T(166) = T(16)*T(62)*T(161)+T(3)*T(62)*T(90)*T(162);
T(167) = getPowerDeriv(T(6),T(13),2);
T(168) = T(90)*T(89)*T(161)+T(3)*T(89)*T(162)*T(167);
T(169) = T(15)*T(16)*T(161)+T(3)*T(15)*T(90)*T(162);
T(170) = getPowerDeriv(T(6),T(1),2);
T(171) = T(2)*(T(95)*T(89)*T(161)+T(3)*T(89)*T(162)*T(170));
T(172) = (-(exp(y(45)*(1-params(3)))*T(1)*exp(T(1)*y(50))*params(3)*exp(y(13)*params(3))));
T(173) = T(16)*T(105)*T(164)+T(19)*T(105)*T(90)*T(162);
T(174) = T(16)*T(106)*T(161)+T(3)*T(106)*T(90)*T(162);
T(175) = T(20)*getPowerDeriv(T(20),params(3),2);
T(176) = T(20)*T(175);
T(177) = T(65)+T(176);
T(178) = getPowerDeriv(T(67),T(1),2);
T(179) = T(63)*(T(68)*T(64)*T(177)+T(64)*T(65)*T(64)*T(65)*T(178));
T(180) = getPowerDeriv(T(67),T(13),2);
T(181) = T(77)*T(64)*T(177)+T(64)*T(65)*T(64)*T(65)*T(180);
T(182) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(183) = T(20)*T(182);
T(184) = T(81)+T(183);
T(185) = exp(y(14))*getPowerDeriv(exp(y(14)),1+params(8),1);
T(186) = (-(params(9)*T(185)/(1+params(8))));
T(187) = getPowerDeriv(T(29),(-params(14)),1);
T(188) = T(186)*T(187);
T(189) = (-((-(params(1)*T(86)*T(188)))/(T(30)*T(30))));
T(190) = (-((-(params(1)*T(99)*T(188)))/(T(30)*T(30))));
T(191) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(192) = T(4)*T(191);
T(193) = T(83)+T(192);
T(194) = (-(params(9)*T(193)/(1+params(8))));
T(195) = getPowerDeriv(T(27),(-params(14)),2);
T(196) = T(85)*T(194)+T(84)*T(84)*T(195);
T(197) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(198) = T(4)*T(197);
T(199) = T(89)+T(198);
T(200) = T(90)*T(3)*T(199)+T(3)*T(89)*T(3)*T(89)*T(167);
T(201) = (-(T(89)*T(19)*T(18)*T(91)+T(16)*T(18)*T(19)*T(199)+T(89)*T(19)*T(18)*T(91)+T(5)*T(19)*T(18)*T(200)));
T(202) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(203) = T(4)*T(202);
T(204) = T(93)+T(203);
T(205) = (-(T(3)*T(15)*T(91)*T(93)+T(17)*T(3)*T(15)*T(200)+T(3)*T(15)*T(91)*T(93)+T(3)*T(15)*T(16)*T(204)));
T(206) = T(2)*(T(95)*T(3)*T(199)+T(3)*T(89)*T(3)*T(89)*T(170));
T(207) = T(28)*T(28)*T(28)*T(28);
T(208) = (-((T(28)*T(28)*(-(T(98)*T(196)))-(-(T(86)*T(98)))*(T(28)*T(86)+T(28)*T(86)))/T(207)));
T(209) = exp(y(46))*T(84)*T(195);
T(210) = T(28)*T(28)*(-(T(98)*T(209)))-(-(T(98)*T(99)))*(T(28)*T(86)+T(28)*T(86));
T(211) = (-(T(89)*T(19)*T(16)*T(105)+T(5)*T(19)*T(91)*T(105)));
T(212) = y(66)*T(211);
T(213) = y(65)*(-(T(93)*T(3)*T(16)*T(106)+T(17)*T(3)*T(91)*T(106)));
T(214) = T(3)*T(89)*T(95)*T(107);
T(215) = T(86)*T(112);
T(216) = T(86)*T(114);
T(217) = exp(y(108))*getPowerDeriv(exp(y(108)),1-params(3),1);
T(218) = T(63)*(T(68)*T(65)*T(217)+T(64)*T(65)*T(178)*T(66)*T(217));
T(219) = exp(y(108))*getPowerDeriv(exp(y(108)),(-params(3)),1);
T(220) = T(77)*T(65)*T(217)+T(64)*T(65)*T(180)*T(66)*T(217);
T(221) = exp(y(108))*getPowerDeriv(exp(y(108)),1+params(8),1);
T(222) = (-(params(9)*T(221)/(1+params(8))));
T(223) = getPowerDeriv(T(97),(-params(14)),1);
T(224) = params(1)*T(222)*T(223);
T(225) = (-((-(params(1)*T(86)*exp(y(15))*T(187)))/(T(30)*T(30))));
T(226) = (-((-(params(1)*T(99)*exp(y(15))*T(187)))/(T(30)*T(30))));
T(227) = T(84)*exp(y(46))*T(195);
T(228) = T(28)*T(99)+T(28)*T(99);
T(229) = (-((T(28)*T(28)*(-(T(98)*T(227)))-(-(T(86)*T(98)))*T(228))/T(207)));
T(230) = T(99)+exp(y(46))*exp(y(46))*T(195);
T(231) = T(99)*T(112);
T(232) = T(99)*T(114);
T(233) = exp(y(48))*getPowerDeriv(exp(y(48)),T(25),2);
T(234) = exp(y(48))*T(233);
T(235) = T(102)+T(234);
T(236) = T(35)*y(21)*(-(T(26)*(-(exp(params(5)*y(11))*params(6)*exp(y(53))))))+T(35)*y(23)*T(26)*params(6)*params(5)*exp(y(53))*exp(y(11)*(params(5)-1));
T(237) = (-(exp(y(111))*(exp(y(38))*exp(y(103))+(1-exp(y(38)))*y(104)-params(6)*exp(y(113))*exp(params(5)*y(38)))));
T(238) = (-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(239) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(50))));
T(240) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(50));
T(241) = T(64)*T(65)*T(68)*(1-params(11))*T(1)*exp(T(1)*y(112));
T(242) = T(74)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(112));
T(243) = T(65)*T(76)*T(242)+T(66)*T(78)*T(242);
T(244) = T(79)*T(78)*T(74)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(112))+T(81)*T(76)*T(74)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(112));
T(245) = T(53)+y(71)*(-(exp(y(111))*(-(params(6)*exp(y(113))*params(5)*exp(params(5)*y(38))))));
T(246) = getPowerDeriv(T(39),params(5)-1,2);
T(247) = (-(exp(y(31))*exp(y(54))*params(6)*(T(39)*T(111)+T(39)*T(39)*T(246))));
T(248) = T(28)*T(247);
T(249) = T(28)*(-(exp(y(31))*exp(y(54))*params(6)*(T(111)*(-T(39))+(-T(39))*T(39)*T(246))));
T(250) = (-(exp(y(31))*exp(y(54))*params(6)*(T(111)*(-T(39))+T(39)*(-T(39))*T(246))));
T(251) = T(28)*T(250);
T(252) = (-(exp(y(31))*exp(y(54))*params(6)*(T(39)*T(111)+(-T(39))*(-T(39))*T(246))));
T(253) = T(28)*T(252);
T(254) = exp(y(6))*params(6)*exp(y(53))*(-params(5))*exp(params(5)*(y(10)-y(62)))*(-params(5));
T(255) = y(68)*T(254);
T(256) = y(80)*T(127)+y(76)*T(131)+T(255);
T(257) = params(30)*y(119)*exp(y(33))*params(6)*exp(y(113))*exp(params(5)*(y(37)-y(114)))*(-params(5))+params(30)*y(122)*(-(exp(y(33))*(-(exp(y(37))*(-exp((-y(114))))))))+params(30)*y(126)*(-(exp(y(33))*exp(y(37))*(-exp((-y(114))))));
T(258) = params(30)*y(126)*(-(exp(y(33))*exp(y(37))*(-exp((-y(114))))))+params(30)*y(122)*(-(exp(y(33))*(-(exp(y(37))*(-exp((-y(114))))))))+params(30)*y(119)*exp(y(33))*params(6)*exp(y(113))*params(5)*exp(params(5)*(y(37)-y(114)))*(-params(5));
T(259) = params(30)*exp(y(33))*params(6)*exp(y(113))*params(5)*exp(params(5)*(y(37)-y(114)));
T(260) = T(35)*(-(T(26)*exp(y(28))*exp(y(11))));
T(261) = T(35)*(-(T(26)*(-(exp(params(5)*y(11))*params(6)*exp(y(53))))));
T(262) = T(35)*T(26)*params(6)*params(5)*exp(y(53))*exp(y(11)*(params(5)-1));
T(263) = params(30)*(-(exp(y(33))*(-(exp((-y(114)))*exp(y(37))))));
T(264) = params(30)*(-(exp(y(33))*exp((-y(114)))*exp(y(37))));

end
